/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.nether;

import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.serialization.jankson.JanksonUtil;
import corgitaco.corgilib.shadow.blue.endless.jankson.api.SyntaxError;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import net.minecraft.class_6908;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.util.BYGUtil;
import potionstudios.byg.util.ModPlatform;

public record NetherBiomesConfig(boolean forceBYGNetherBiomeSource, boolean addAllNetherBiomeTagEntries, int layerSize, LayersBiomeData upperLayer, LayersBiomeData middleLayer, LayersBiomeData bottomLayer) {
    public static final Supplier<Path> LEGACY_CONFIG_PATH = () -> ModPlatform.INSTANCE.configPath().resolve("byg-nether-biomes.json");
    public static final Supplier<Path> CONFIG_PATH = () -> ModPlatform.INSTANCE.configPath().resolve("nether-biomes.json5");
    public static final Codec<NetherBiomesConfig> LEGACY_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("useBYGNetherBiomeSourceInNewWorlds").forGetter(netherBiomesConfig -> netherBiomesConfig.forceBYGNetherBiomeSource), (App)Codec.BOOL.fieldOf("addAllEndBiomeCategoryEntries").forGetter(netherBiomesConfig -> netherBiomesConfig.addAllNetherBiomeTagEntries), (App)Codec.INT.fieldOf("layerSizeInBlocks").forGetter(netherBiomesConfig -> netherBiomesConfig.layerSize), (App)LayersBiomeData.CODEC.fieldOf("upperLayer").forGetter(netherBiomesConfig -> netherBiomesConfig.upperLayer), (App)LayersBiomeData.CODEC.fieldOf("middleLayer").forGetter(netherBiomesConfig -> netherBiomesConfig.middleLayer), (App)LayersBiomeData.CODEC.fieldOf("bottomLayer").forGetter(netherBiomesConfig -> netherBiomesConfig.bottomLayer)).apply((Applicative)builder, NetherBiomesConfig::new));
    public static final Codec<NetherBiomesConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("forceBYGNetherBiomeSource").forGetter(netherBiomesConfig -> netherBiomesConfig.forceBYGNetherBiomeSource), (App)Codec.BOOL.fieldOf("addAllNetherBiomeTagEntries").forGetter(netherBiomesConfig -> netherBiomesConfig.addAllNetherBiomeTagEntries), (App)Codec.INT.fieldOf("layerSizeInBlocks").forGetter(netherBiomesConfig -> netherBiomesConfig.layerSize), (App)LayersBiomeData.CODEC.fieldOf("upperLayer").forGetter(netherBiomesConfig -> netherBiomesConfig.upperLayer), (App)LayersBiomeData.CODEC.fieldOf("middleLayer").forGetter(netherBiomesConfig -> netherBiomesConfig.middleLayer), (App)LayersBiomeData.CODEC.fieldOf("bottomLayer").forGetter(netherBiomesConfig -> netherBiomesConfig.bottomLayer)).apply((Applicative)builder, NetherBiomesConfig::new));
    public static NetherBiomesConfig INSTANCE = null;
    public static final NetherBiomesConfig DEFAULT = new NetherBiomesConfig(true, true, 40, LayersBiomeData.DEFAULT_NETHER_UPPER, LayersBiomeData.DEFAULT_NETHER_MIDDLE, LayersBiomeData.DEFAULT_NETHER_LOWER);

    public static NetherBiomesConfig getConfig() {
        return NetherBiomesConfig.getConfig(false, false, null);
    }

    public static NetherBiomesConfig getConfig(boolean serialize) {
        return NetherBiomesConfig.getConfig(serialize, false, null);
    }

    public static NetherBiomesConfig getConfig(boolean serialize, boolean recreate, @Nullable class_2378<class_1959> additional) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = NetherBiomesConfig.readConfig(recreate);
        }
        if (additional != null && INSTANCE.addAllNetherBiomeTagEntries()) {
            class_6005 registryDefaults = ((class_6005.class_6006)class_156.method_654((Object)class_6005.method_34971(), builder -> additional.method_10220().map(arg_0 -> ((class_2378)additional).method_29113(arg_0)).map(Optional::get).map(arg_0 -> ((class_2378)additional).method_40290(arg_0)).filter(biomeHolder -> biomeHolder.method_40220(class_6908.field_36518)).map(biomeHolder -> (class_5321)biomeHolder.method_40230().orElseThrow()).forEach(biomeResourceKey -> builder.method_34975(biomeResourceKey, 2)))).method_34974();
            BiPredicate<Collection, class_5321> filter = (existing, added) -> !existing.contains(added);
            NetherBiomesConfig registryUpdatedConfig = new NetherBiomesConfig(INSTANCE.forceBYGNetherBiomeSource(), INSTANCE.addAllNetherBiomeTagEntries(), INSTANCE.layerSize(), new LayersBiomeData(INSTANCE.upperLayer().biomeWeights(), INSTANCE.upperLayer().biomeSize()), new LayersBiomeData(BYGUtil.combineWeightedRandomLists(filter, INSTANCE.middleLayer().biomeWeights(), registryDefaults), INSTANCE.middleLayer().biomeSize()), new LayersBiomeData(BYGUtil.combineWeightedRandomLists(filter, INSTANCE.bottomLayer().biomeWeights(), registryDefaults), INSTANCE.bottomLayer().biomeSize()));
            NetherBiomesConfig.createConfig(CONFIG_PATH.get(), registryUpdatedConfig);
            INSTANCE = registryUpdatedConfig;
        }
        return INSTANCE;
    }

    private static NetherBiomesConfig readConfig(boolean recreate) {
        Path legacyPath = LEGACY_CONFIG_PATH.get();
        Path path = CONFIG_PATH.get();
        NetherBiomesConfig config = DEFAULT;
        if (legacyPath.toFile().exists()) {
            try {
                FileReader reader = new FileReader(legacyPath.toFile());
                config = (NetherBiomesConfig)((Pair)LEGACY_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).result().orElseThrow(() -> BYGUtil.configFileFailureException(legacyPath))).getFirst();
                reader.close();
                Files.delete(legacyPath);
            }
            catch (IOException e) {
                BYG.logError("Could not create new config file for: " + legacyPath.toString());
                e.printStackTrace();
                return config;
            }
        }
        if (!path.toFile().exists() || recreate) {
            NetherBiomesConfig.createConfig(path, config);
        }
        BYG.logInfo(String.format("\"%s\" was read.", path.toString()));
        try {
            return (NetherBiomesConfig)JanksonUtil.readConfig((Path)path, CODEC, (DynamicOps)JanksonJsonOps.INSTANCE);
        }
        catch (SyntaxError | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void createConfig(Path path, NetherBiomesConfig configToSerialize) {
        Map comments = (Map)class_156.method_654(new HashMap(), map -> {
            map.put("forceBYGNetherBiomeSource", "Is BYG's Nether Biome Source used?\nBYG's nether biome source will automatically add all known nether biomes that specify their biomes in the \"minecraft:is_nether\" tag, see \"addAllNetherBiomeTagEntries\" comment.");
            map.put("addAllNetherBiomeTagEntries", "Does this config automatically fill with all values specified in the \"minecraft:is_nether\" biome tag?");
            map.put("bottomLayer", "Biomes that appear at the bottom of the nether dimension.\nThis layer appears in the y range of: \"dimension min Y to layer size\".");
            map.put("middleLayer", "Biomes that appear at the middle of the nether dimension above the bottom layer.\nThis layer appears in the y range of: \"layer size to (layer size + layer size)\".\nie. y40 to y80 if layer size is 40 or y60 to y120 if layer size is 60.");
            map.put("topLayer", "Biomes that appear at the top of the nether dimension above the middle layer.\nThis layer appears in the y range of: \"layer size + layer size to dimension max Y\".\nie. y80 to dimension max Y if layer size is 40 or y120 to dimension max Y if layer size is 60.");
            String biomeWeights = "Higher weight, means the biome in question is bound to spawn more frequently against all other biomes listed here.\nWeight of 0 means the biome is disabled.\n\n\"data\" should be a valid biome ID from vanilla, mods, or datapacks.\nIf the biome in question is not in the biome registry, the biome is ignored & logged in the \"latest.log\".\n";
            map.put("bottomLayer.biomeWeights", biomeWeights);
            map.put("middleLayer.biomeWeights", biomeWeights);
            map.put("topLayer.biomeWeights", biomeWeights);
        });
        String netherConfigHeader = "If your settings in this file seem to have to no effect on the generation of the nether, it is more than likely that another mod(s) related to the nether has taken control instead, and you should user their config.";
        JanksonUtil.createConfig((Path)path, CODEC, (String)("/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n\n" + netherConfigHeader + "\n*/"), (Map)comments, (DynamicOps)JanksonJsonOps.INSTANCE, (Object)configToSerialize);
    }
}

